<?php
require_once __DIR__ . '/../includes/config.php';
if (!FB_ENABLED) return;

$url = "https://graph.facebook.com/v19.0/" . urlencode(FB_PAGE_ID)
     . "/posts?fields=message,permalink_url,created_time"
     . "&limit=" . intval(FB_LIMIT)
     . "&access_token=" . urlencode(FB_PAGE_ACCESS_TOKEN);

$ch = curl_init($url);
curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]);
$res = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http !== 200 || !$res) { echo '<p class="help">Facebook indisponível (token/permissões).</p>'; return; }

$data = json_decode($res, true);
$items = $data['data'] ?? [];
if (!$items) return;

echo '<div style="margin-top:10px">';
foreach ($items as $it) {
  $msg = $it['message'] ?? '';
  $link = $it['permalink_url'] ?? '#';
  echo '<div class="card pad" style="margin-bottom:10px">';
  echo '<div class="help">'.htmlspecialchars(pa_strim($msg, 0, 220, '…')).'</div>';
  echo '<div style="margin-top:10px"><a class="btn secondary" href="'.htmlspecialchars($link).'" target="_blank" rel="noopener">Ver publicação</a></div>';
  echo '</div>';
}
echo '</div>';
